/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core;

import com.aptana.core.util.EclipseUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.Messages;
import com.aptana.git.core.model.IGitRepositoryManager;
import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.RepositoryProviderType;

public class GitRepositoryProviderType
extends RepositoryProviderType {
    public void metaFilesDetected(IProject project, IContainer[] containers) {
        if (this.getGitRepositoryManager().getAttached(project) != null) {
            return;
        }
        if (this.autoAttachGitRepos() && this.hasGitDir(project)) {
            final IProject toConnect = project;
            Job job = new Job(Messages.GitRepositoryProviderType_AutoShareJob_Title){

                protected IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(MessageFormat.format(Messages.GitRepositoryProviderType_AttachingProject_Message, toConnect.getName()), 100);
                    try {
                        GitRepositoryProviderType.this.getGitRepositoryManager().attachExisting(toConnect, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        monitor.done();
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            EclipseUtil.setSystemForJob((Job)job);
            job.schedule();
        }
    }

    protected boolean hasGitDir(IProject project) {
        IResource dotGit = project.findMember(".git");
        return dotGit != null && dotGit.exists();
    }

    private boolean autoAttachGitRepos() {
        return Platform.getPreferencesService().getBoolean(GitPlugin.getPluginId(), "auto_attach_repos", true, null);
    }

    protected IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }
}

